"""
ar_operator_core
================

Top‑level shim that re‑exports the five fundamental tick‑flip operators
(`F`, `S`, `X`, `C`, and `Φ`/`Phi`) from the underlying
:mod:`flip_operators` package.

This module exists to provide the interface expected by the Absolute
Relativity verification harness.  Client code can import the operators
directly from :mod:`ar_operator_core` or via submodules such as
``ar_operator_core.ops`` without depending on the internal structure of
:mod:`flip_operators`.
"""

from __future__ import annotations

# Import the operator implementations from flip_operators
try:
    from flip_operators.renewal import F as F  # Renewal (outward flip)
    from flip_operators.sinking import S as S  # Sink (inward flip)
    from flip_operators.distinction import X as X  # Distinction (reflection)
    from flip_operators.sync import C as C  # Sync (symmetric projection)
    from flip_operators.frame_coupling import Phi as Phi  # Frame coupling
except Exception as exc:
    raise ImportError(
        "Failed to import core operators from flip_operators: " f"{exc}"
    )

# Greek alias for Phi; some code references the Greek letter explicitly
Φ = Phi

# Public API
__all__ = ["F", "S", "X", "C", "Φ", "Phi"]